#version 330
#extension GL_EXT_gpu_shader4 : enable
//Rainbow wavesMod01.fsh  by   ParaBellum
//https://www.shadertoy.com/view/wlXSRM
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.628318 //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

#define PI 3.141592

vec3 red = vec3(1., 0., 0.);
vec3 orange = vec3(1., .49803, .0);
vec3 yellow = vec3(1., 1., 0.);
vec3 green = vec3(0., 1., 0.);
vec3 blue = vec3(0., 0., 1.);
vec3 purple = vec3(.2941, .0, .5098);
vec3 pink = vec3(.5803, .0, .8274);

// This shader is inspired from this shader: 
// https://www.shadertoy.com/view/4l2XWK made by Shane.

// Function based on https://www.shadertoy.com/view/MlSSDV
// from FabriceNeyret2's shader
// originated from Fantomas' shader - https://www.shadertoy.com/view/ltSSDV
float mixing(vec2 p)
{
    p *= 2.6;
    float t = iTime*.1;
    for (int i = 0; i <= 1; i++)
    {
    	p += cos(p.yx * 3. + vec2(t, 1.6)) / 3.;
        p += sin(p.yx + vec2(1.6+t, t)) / 2.;
        p *= .6;
    }
    
    p = abs(fract(p)*2.-1.);
    return max(p.x,p.y);
}
void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    vec3 colors[7];
    colors[0] = red;
    colors[1] = orange;
    colors[2] = yellow;
    colors[3] = green;
    colors[4] = blue;
    colors[5] = purple;
    colors[6] = pink;
    
    vec2 frag = gl_FragCoord.xy;
    vec2 uv = frag/iResolution.xy*2.-1.;
    uv.x *= iResolution.x/iResolution.y;
    
    vec2 e = vec2(1., 0.);
    vec2 ms = iMouse.xy/iResolution.xy*2.-1.;
    ms.x *= iResolution.x/iResolution.y;
    
    vec2 r_uv = (frag+e.xy)/iResolution.xy*2.-1.;
    r_uv.x *= iResolution.x/iResolution.y;
    
    vec2 a_uv = (frag+e.yx)/iResolution.xy*2.-1.;
    a_uv.x *= iResolution.x/iResolution.y;
    
    float h = mixing(uv);
    float r_h = mixing(r_uv);
    float a_h = mixing(a_uv);
    
    vec3 fragPos = vec3(uv, h);
    vec3 r_fragPos = vec3(r_uv, r_h);
    vec3 a_fragPos = vec3(a_uv, a_h);
    
    vec3 a = (r_fragPos - fragPos);
    vec3 b = (a_fragPos - fragPos);
    
    vec3 nor = normalize(cross(a, b));
    vec3 lightPos = vec3(ms, 3.);
    vec3 lightDir = normalize(lightPos-fragPos);
    float al = h*.5;
    float dl = max(dot(nor, lightDir), 0.)*.75;
    vec3 eyePos = vec3(0., 0., 2.);
    vec3 halfWay = normalize(lightPos+eyePos);
    float sl = pow(max(dot(nor, halfWay), 0.), 32.);
    vec3 light = al*vec3(0.5) + dl*vec3(1., .9, .7) + sl*vec3(.9, .8, .8);
    
    vec3 col = vec3(0.);
    col += light;
    
    for (int i = 0; i < 7; i++)
        if (h > (1./7.*float(i)) && h < (1./7.*float(i+1)))
            col *= mix(colors[i], colors[6-i], sin(iTime*.5))*light;
    
    gl_FragColor = vec4(sqrt(clamp(col, 0., 1.)),1.0);
}